/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.servlet.logd.LogServletMsg;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileFn {
    private static final String TRACE_MASKT = "XLDSFFFT";
    private static final String TRACE_MASKF = "XLDSFFFF";
    private static final String TRACE_MASKD = "XLDSFFFD";
    private static final String ID_LIST = "listOfFiles";
    private static final char NEW_LINE = '\n';
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String write2File(HttpServletRequest request, HttpServletResponse response, String[] aFileList, StringBuffer text, String id) throws HException, IOException {
        Trace.trace(TRACE_MASKT, "-> FileFn.write2File() for " + id);
        OutputStreamWriter out = null;
        File tmpSaveFile = null;
        String tmpSaveFileName = null;
        try {
            try {
                if (id.equals(ID_LIST)) {
                    File directory = new File(BaseFileControl.getFilePath("tmp"));
                    tmpSaveFile = File.createTempFile("LogSave", ".trm", directory);
                    tmpSaveFileName = tmpSaveFile.getAbsolutePath();
                    Trace.trace(TRACE_MASKF, "tmp save file Name =[" + tmpSaveFileName + "] for" + id);
                    out = new FileWriter(tmpSaveFile);
                    int len = aFileList.length;
                    Trace.trace(TRACE_MASKF, "Write the list of files(to be zipped)  to a file.  numFiles=" + len);
                    for (int i = 0; i < len; ++i) {
                        Trace.trace(TRACE_MASKF, "i=" + i + " file=" + aFileList[i]);
                        out.write(aFileList[i] + '\n');
                    }
                }
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, "In FileFn.write2File(). Caught IOException. for " + id);
                HException he = new HException(ioe);
                FrameworkLog fLog = new FrameworkLog(_logInfo, 2185, he);
                fLog.add(id);
                fLog.log();
                throw he;
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            Trace.trace(TRACE_MASKF, "-> in finally.  FileFn.write2File() for" + id);
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, id + ": in write2File finally: Caught IOException closing file.");
                HException he = new HException(ioe);
                FrameworkLog fLog = new FrameworkLog(_logInfo, 2187, he);
                fLog.add(id);
                fLog.log();
                throw he;
            }
        }
        Trace.trace(TRACE_MASKF, "-> in finally.  FileFn.write2File() for" + id);
        try {}
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, id + ": in write2File finally: Caught IOException closing file.");
            HException he = new HException(ioe);
            FrameworkLog fLog = new FrameworkLog(_logInfo, 2187, he);
            fLog.add(id);
            fLog.log();
            throw he;
        }
        if (out != null) {
            out.close();
        }
        Trace.trace(TRACE_MASKT, "<- FileFn.write2File() for" + id);
        return tmpSaveFileName;
    }

    protected static void createSendFileList(HttpServletRequest request, HttpServletResponse response) throws HException, IOException {
        Trace.trace(TRACE_MASKT, "-> FileFn.createSendFileList()");
        String[] aFileList = request.getParameterValues("listFile");
        if (aFileList == null) {
            LogServletMsg.displayMsg(request, response, "xlds.viewdata.title", "XLDSSAFS", MsgType.INFORMATION_MESSAGE);
        } else {
            int count = 0;
            int aLen = aFileList.length;
            StringBuffer badFiles = new StringBuffer();
            for (int i = 0; i < aLen; ++i) {
                File f = new File(aFileList[i]);
                if (f.exists() && f.canRead()) continue;
                if (++count == 1) {
                    badFiles.append("<UL>");
                }
                badFiles.append("<LI>" + aFileList[i]);
                Trace.trace(TRACE_MASKF, "File no longer exists/accessible= " + aFileList[i]);
            }
            if (count != 0) {
                badFiles.append("<UL>");
                Trace.trace(TRACE_MASKF, "aFileList=" + badFiles.toString());
                LogServletMsg.displayMsgArg(request, response, "xlds.viewdata.title", "XLDSNFZS", MsgType.INFORMATION_MESSAGE, badFiles.toString());
            } else {
                String fileName = FileFn.write2File(request, response, aFileList, null, ID_LIST);
                String zipItCmd = "/hmc/support?reqtype=listoffiles&InputData=" + fileName + "&erase=true";
                Trace.trace(TRACE_MASKF, "Sending this to redirect=" + zipItCmd);
                response.sendRedirect(response.encodeRedirectURL(zipItCmd));
            }
        }
        Trace.trace(TRACE_MASKT, "<- FileFn.createSendFileList()");
    }

    public static String fullyQualify(String fileName) throws HException {
        Trace.trace(TRACE_MASKT, "-> FileFn.fullyQualify()");
        if (!fileName.startsWith(File.separator)) {
            String path = System.getProperty("CONSOLE_PATH");
            if (path != null) {
                fileName = path + fileName;
            } else {
                Trace.trace(TRACE_MASKF, "Can't get the CONSOLE_PATH.");
                HException he = new HException("Can't get the CONSOLE_PATH");
                FrameworkLog fLog = new FrameworkLog(_logInfo, 2193, he);
                fLog.add("filename to qualify=" + fileName);
                fLog.log();
                throw he;
            }
        }
        Trace.trace(TRACE_MASKF, "Fully qualified name selected=[" + fileName + "]");
        Trace.trace(TRACE_MASKT, "<- FileFn.fullyQualify()");
        return fileName;
    }
}

